<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// directory reading class

/**
* Handles reading various directories
*
* @package	Forumon
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class VBSIGNATURES_FILE
{
	/**
	* Array of found items
	*
	* @public	array
	*/	
	protected static $map = array();

	/**
	* Fetches configuration files for the species
	*/
	public static function fetchAllParts()
	{
		// Scan the areas directory for images
		self::scan(DIR . '/dbtech/vbsignatures/images/parts', array('png'));
		
		$filearray = array();
		foreach (self::$map as $filepath => $item)
		{
			$filepath = str_replace(array(
				DIR . '/dbtech/vbsignatures/images/parts/',
				$item
			), '', $filepath);
			
			// Finalise the filepath to only get the folder name
			$filepath = ($filepath ? substr($filepath, 0, -1) : '');

			// Store the file array
			$filearray[$filepath][] = $item;
		}
		
		// Store the bg image
		return $filearray;
	}	

	/**
	* Checks if the extension is meant to be included
	*
	* @param	string	The filename to check
	* @param	array	The list of valid extensions
	*/	
	protected static function extension($name = '', $match = array())
	{
		// Check if the extension is in the valid list
		return in_array(self::fetch_extension($name), $match);
	}
	
	/**
	* Fetches the extension based on the filename
	*
	* @param	string	The filename to extract extension from
	*/	
	protected static function fetch_extension($name)
	{
		// Split the filename by the extension separator
		$ext = explode('.', $name);
		
		return strtolower($ext[count($ext) - 1]);		
	}

	/**
	* Fetches the filename without the extension
	*
	* @param	string	The filename to remove extension from
	*/	
	protected static function fetch_filename($name)
	{
		// Split the filename by the extension separator
		$ext = explode('.', $name);
		
		// Get rid of the filename
		unset($ext[count($ext) - 1]);
		
		// Return the re-joined filename
		return implode('.', $ext);		
	}

	/**
	* Checks if the item name is valid
	*
	* @param	string	The item name to check
	*/	
	protected static function valid($item = '')
	{
		// Don't include special directories and .db files
		return $item != '.' AND $item != '..' AND !preg_match("#\.db$#i", $item);
	}

	/**
	* Actually scans the directory
	*
	* @param	string	The directory to scan
	* @param	array	The item name to check
	* @param	boolean	Are we checking subdirectories?
	* @param	boolean	Are we listing directories?
	*/	
	protected static function scan($dir = '', $extensions = array(), $subdirs = true, $dirlist = false)
	{
		if (!is_dir($dir) OR !is_readable($dir))
		{
			// Either not a directory, or can't be read
			return false;
		}
		
		// Open a directory handler
		$d = dir($dir);
		while (($item = $d->read()) !== false)
		{
			if (!self::valid($item) OR !is_readable($dir . '/' . $item))
			{
				// Invalid item or not readable
				continue;
			}
			
			if (is_dir($dir . '/' . $item))
			{
				if ($dirlist)
				{
					// List directories
					self::$map[$dir . '/' . $item] = $item;
				}
				
				if (!$subdirs)
				{
					// We're not including subdirectories
					continue;
				}
				
				// Scan the sub-directory
				self::scan($dir . '/' . $item, $extensions);
			}
			else if ((empty($extensions) OR self::extension($item, $extensions)) AND !$dirlist)
			{
				// Add this item
				self::$map[$dir . '/' . $item] = $item;
			}
		}
		
		// Close the directory handler, we're done
		$d->close();
	}
}


/*======================================================================*\
|| ####################################################################
|| # Created: 22:58, Mon Aug 23rd 2010
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/